#pragma once

#include "BowerShader.h"

using namespace std;
using namespace DirectX;

//A complex shader which tessellates, displaces and self-shadows the main terrain plane
class TerrainTessellationShader : public BowerShader
{
	public:
		struct SobelBufferType
		{
			float sobelScaleFactor;	//Scaling for the smoothness/roughness of the light, defined by the normals calculated via Sobel
			XMFLOAT3 padding;
		};

		struct NormalsBufferType
		{
			int normalMode;	//An int used to represent whether to show normals in the pixel shader (int used here due to differences of padding between C++ and HLSL)
			XMFLOAT3 padding;
		};

		TerrainTessellationShader(ID3D11Device* device, HWND hwnd);
		~TerrainTessellationShader();

		void setShaderParameters(ID3D11DeviceContext* deviceContext, const XMMATRIX &world, const XMMATRIX &view, const XMMATRIX &projection, XMFLOAT3 cameraPos, float minTessFactor, float maxTessFactor, float sobelScaleFactor, ID3D11ShaderResourceView* displacementTexture, ID3D11ShaderResourceView* textureMap, ID3D11ShaderResourceView* grassTexture, ID3D11ShaderResourceView* rockTexture, ID3D11ShaderResourceView* dirtTexture, ID3D11ShaderResourceView* sandTexture, ID3D11ShaderResourceView* sunShadowMap, ID3D11ShaderResourceView* spotShadowMap, ID3D11ShaderResourceView* hillShadowMaps[6], float constant, float linear, float quadratic, bool normalMode);

	private:
		void initShader(const wchar_t* vsFilename, const wchar_t* psFilename);
		void initShader(const wchar_t* vsFilename, const wchar_t* hsFilename, const wchar_t* dsFilename, const wchar_t* psFilename);

		ID3D11Buffer* matrixBuffer;
		ID3D11Buffer* normalBuffer;	//Buffer for normal mode
		ID3D11Buffer* sobelBuffer;	//Buffer for Sobel scaling
		ID3D11Buffer* dynamicTessBuffer;	//Buffer for tessellation factors
		ID3D11Buffer* lightBuffer;
		ID3D11SamplerState* sampleStateShadow;
};
